(* ::Package:: *)

(* Copyright 1997-2011 by California Inst. of Technology, Pasadena, CA. *)

(* Only call this package file from CurveFit`Palette.m *)

(* The code assumes that we are already in the 
	CurveFit`Palette`Private 
	context. *)

(* Interface.m - Data interface to Mathematica *)


(***********************************************************)
(* Data interface main palette selections *) 

interfacemenu := 
Tooltip[
ActionMenu["Data Interface",
{
	"Get lists of data values" :>  getdatapalette[],
	Delimiter,
	"Get the number of data points"  :> insertinline["GetData[\"N\"]"]
}
],
"Functions to access or interface the CurveFit data\n"<>
"with your own Mathematica routines"
]

interfacemenu::usage = "Each subpalette of the \"Data Interface\" "<>
 "menu selection provides help for its items.";

interfacehelp := 
Tooltip[
Button["Help", 
	eval["?CurveFit`Palette`Private`interfacemenu"];
],
"Each subpalette provides its own help button"]

interfaceitem := {interfacehelp, interfacemenu}



(***********************************************************)
(* Get data from CurveFit sub palette *) 

getdatapalette[] := (
	NotebookClose[CurveFitPalette];
	CurveFitPalette =
	CreatePalette[
		Column[{
			backtomain,
			Tooltip[
			Button["Help",
				TextHint["Each button in the \"Get CurveFit Data\" palette "<>
					"inserts a call to the GetData[ ] function at the "<>
					"input notebook's selection point. You can then use the "<>
					"returned list of values in a Mathematica expression. The "<>
					"GetData function is described below."
				]; 
				eval["?CurveFit`GetData"]
				],
				"Provides a description of what these selections do"],
			Tooltip[
			Button["Get the X values", 
					insertinline["GetData[\"X\"]"]; mainpalette
				],
				"Return a list of the data's X values"],
			Tooltip[
			Button["Get the Y values", 
					insertinline["GetData[\"Y\"]"]; mainpalette
				],
				"Return a list of the data's Y values"],
			Tooltip[
			Button["Get the X sigmas", 
					insertinline["GetData[\"SX\"]"]; mainpalette
				],
				"Return a list of the data's X uncertainties"],
			Tooltip[
			Button["Get the Y sigmas", 
					insertinline["GetData[\"SY\"]"]; mainpalette
				],
				"Return a list of the data's Y uncertainties"],
			Tooltip[
			Button["Get the {X,Y} points", 
					insertinline["GetData[\"XY\"]"]; mainpalette
				],
				"Return a list of the data's {X,Y} pairs,\n"<>
				"e.g. suitable for plotting with ListPlot"],
			Tooltip[
			Button["Get {X\[PlusMinus]\[Sigma]x,Y\[PlusMinus]\[Sigma]y} pairs", 
					insertinline["GetData[\"ALL\"]"]; mainpalette
				],
				"Return a list of {X\[PlusMinus]\[Sigma]x,Y\[PlusMinus]\[Sigma]y} pairs, with sigmas,\n"<>
				"e.g. suitable for plotting with ErrorListPlot"]
			},
			Alignment -> Left
		],
		WindowTitle->"Get CurveFit Data",
		Saveable->False, NotebookEventActions->{"WindowClose":>mainpalette}
	];
)

