(* ::Package:: *)

(* Copyright 1997-2021 by California Inst. of Technology, Pasadena, CA. *)

(* Only call this package file from CurveFit`Palette.m *)

(* The code assumes that we are already in the 
	CurveFit`Palette`Private 
	context. *)

(* File loaded by CurveFit`Palette.m *)



(***********************************************************)
(* Fit Analysis main palette selections *) 

analyzemenu := 
Tooltip[
ActionMenu["Fit Analysis",
{
	"Get the number of data points"  :> eval["GetData[\"N\"]"],
	"Display results of the last fit" :> eval[
		"Column[{Style[fYstring,Bold],\[IndentingNewLine]		Style[\"  Fit data points: \"<>ToString[Nfit]<>\"\n  Optimized parameters: \"<>ToString[Pfit]],\[IndentingNewLine]		Tfit,Framed[FitResults]}]"		
		],
	"Reduced Chi-squared using current data" :> eval["ChiSquared[]"],
	"Replace Y with normalized fit residuals" :> eval[
		"SaveForUndo[]; yy = NormedResiduals[]; sy = 0sy+1.; sx = 0sx;"
		]
}
],
"Functions to access or analyze a fit of the CurveFit data"
]

analyzemenu::usage = "Functions to perform various manipulations and "<>
	"analyses of the results of a fit. Any sub-palette which may be "<>
	"opened by a menu selection provides help for its items.";

analyzehelp := 
Tooltip[
Button["Help", 
	TextHint[analyzemenu::usage];
	eval[
		"Information[StringExpression[\"CurveFit`ChiSquared\"|\"CurveFit`NormedResiduals\"]]"
		]
],
 "Inserts info about these functions in the input notebook. Any "<>
 "sub-palette which may be opened by a menu selection provides "<>
 "help for its items."
 ]

analyzeitem := {analyzehelp, analyzemenu}

