(* ::Package:: *)

(* initialization file for the CurveFit data analysis package CurveFit` *)
If[(12.2 <= $VersionNumber < 13.0) || (13.3 <= $VersionNumber),
	If[!MemberQ[$Packages,"CurveFit`"]||ChoiceDialog[
			Beep[];
			"Are you Sure?\nReloading the CurveFit package will "<>
			"erase all data and repair any corrupted function "<>
			"definitions. If you just need to restore the CurveFit "<>
			"palettes, then choose \"Restart CurveFit\".",
			{"Restart CurveFit":>(CurveFit;False),  
			 " Cancel "->False,
			 "Reload Package"->True},
			WindowFloating->True],
		Get["CurveFit`CurveFit`"];
		Get["CurveFit`Palette`"];
		Print["CurveFit for Mathematica v12.2 - v12.3 and \[GreaterEqual] v13.3, Version 1.99g, 4/14/2024"];
		Print["F. Rice, Caltech, Pasadena, CA"];
		CurveFit`Palette`CurveFit
	],
	Block[{CurveFit},
		CurveFit::version = 
		"You need Mathematica Version 12.2-12.3 or 13.3 or later for this package!";
		Message[CurveFit::version];
	],
	Block[{CurveFit},
		CurveFit::version = 
		"You need Mathematica Version 12.2-12.3 or 13.3 or later for this package!";
		Message[CurveFit::version];
	]
]

