(* ::Package:: *)

(* :Title: CurveFit Data Analysis Package *)

(* :Author: F. Rice, D. Skelton, A. Vayonakis, B. D'Urso,
 California Inst. of Technology *)

(* :Summary:
This package provides tools to visualize, manipulate, and fit 
two-dimensional data with some chosen function. The data may 
have errors on both variables (x,y). *)

(* :Context: CurveFit` *)

(* :Package Version: 1.99g *)

(* :Copyright: Copyright 1997-2024 by 
California Inst. of Technology, Pasadena, CA. *)
(***********************************************************)
(*
              CurveFit for Mathematica v12.x thru v13.x
                    F. Rice, Pasadena, CA
                    
1.99g (4/2024): Fixed a residual plot bug when fY[x] is an interpolation

1.99f (3/2024): Fixes a subtle but pernicious bug: the file load and
select columns dialog box displayed plot switched x and y sigmas.
                    
1.99e (1/2024): Fixes a bug in 1.99d: now can display a residual plot of
a fit to data which may not have specified uncertainties (unweighted data
fit).
                    
1.99d (1/2024): No longer uses ErrorListPlot code. Doesn't use the
ErrorBarLogPlots package. Uses Mathematica's new Around[] for some error
propagation (generating residual plots) By default sets PlusMinus = Around.
                    
1.99c (3/2022): Added capability to load Ortec ".Spe" gamma spectrum files,
among other minor enhancements.

1.99b (1/2021): Fixed a bug in the Data I/O -> Merge Frequency Response
File menu item. It would not actually merge the current data with the file.

1.99a (1/2021): Fixed a bug in the Modify Data Points -> Keep an X-range
quick selection menu item. It would improperly handle log scales.

1.99 (1/2021): Compatible with Mathematica v12.x. Cleaned up and
improved the user interface in the Installer notebook. Improved the
header comments in the sample data files. Added some functionality.
IMPORTANT NOTE: Even though Mathematica version 12 and subsequent 
have the built-in capability to plot data with error bars, this 
version of CurveFit still uses its own error-bar plotting code,
which is currently more capable and flexible than the built-in
Mathematica code.

1.96 (4/2018): Compatible with Mathematica v11.x. Fixed data subrange
selection dialog boxes to fit on various screens. Modified 
ScatterDataPlot.

1.95 (1/2016): Works with the updated ErrorBarLogPlots 3.0, so that it now 
works with Mathematica 10.x. Increased default error bar thickness to Medium

1.91 (1/2015): Check for Mathematica v10 and abort package install. Changed
example in "Fit any function.nb" to fit decaying sinusoid. Commented out 
load of PlotLegends package in Plots.m.

1.9 (3/2014): Added scatter plot function for Compton scattering
experiment data files (x channel v. y channel).

1.8 (1/2014): Fixed problem with some dialog boxes appearing too
large with certain laptop monitor display aspect ratios.

1.7 (1/2013): Added several algebraic manipulations to the Transform
sub-palette.

1.6 (5/2012): Added LoadTekFile[]. Removed "E" default comment delimiter.
Fixed file load error message if there is no file header.

1.5 (12/2011): Various fixes and tweaks. Significant expansion of the
interactive loading and manipulation of data sets and the undo stack.

1.4 (5/2009): Fixed problem with MakePoisson[] on unsorted data.
Added SortData[].

1.3 (3/2009): Added data manipulations for gamma ray spectra.
Changed exponential fits so that non-positive Y values don't
abort the fits. Added capability to input USB-20 .tsv files.

1.2 (1/2009): Added resonance phase fit. Many palette cosmetic
changes. Removed RC filter fits, as they seem buggy. Miscellaneous 
minor improvements.

1.1 (3/2008): Included input parsing for Spectrum Techniques .TSV 
gamma-ray spectrum files, as well as enhancements for processing
multichannel analyzer count data. Some other minor improvements.

1.0 (1/2008): First port of CurveFit to Mathematica v6.x. 
Incorporated several enhancements over CurveFit for Mathematica 5.

*)
(***********************************************************)
(*
                CurveFit written by A. Vayonakis 
	           Initial code was written in Nov. 97

Additions/modifications made on 12/11/07:
Fixed syntax problems with the use of Compile[] in the fitting 
function definitions. No more errors with Mathematica 5, and 
much faster fitting.

Additions/modifications made on 1/25/06:
Replaced the Block with the ReadList function in the LoadFile 
functions, with Import (needs v .4).  Reading large files 
should be much faster.

Additions/modifications made on 2/27/03:
Changed the LoadFile code to be more robust: 
Now, a line whos first non-empty character is any of the user 
chosen delimiters: {"E", "S", etc.}, will be ingored. Also, 
made a separate palette for more options loading the data (eg. 
to have separate button for the E option: selecting 
combinations of columns to define the data.) Added 
MagSecondOrderLowPassFilter, which is has the same functional 
format with resonance curve (N), but with different variable 
definitions.  

Additions/modifications made on 2/25/03:
Added 1st order low-pass, and 1st order high-pass (2nd order 
low-pass filters can use resonance curve (N)) for ph3.
  
Previous additions/modifications were made on 6/06/00.
*)



BeginPackage["CurveFit`"];

(* clear everything first, so the package may be read twice *)
Unprotect["`*"]; 
ClearAll["`*"];

(***********************************************************)
Begin["`Private`"];

Unprotect["`*"]; 
ClearAll["`*"];

(* We want to turn off some messages, 
  but be able to restore them to their original status. *)
spell1Flag = Head[General::spell1] === String;
Off[General::"spell1"]
spellFlag = Head[General::spell] === String;
Off[General::"spell"]
commaFlag = Head[Syntax::com] === String;
Off[Syntax::"com"]
shdwFlag = Head[General::shdw] === String;
Off[General::"shdw"]

End[ ]; (* `Private` *)

(***********************************************************)
(* Load the code. Always get in the order given here *)
Get[ToFileName["CurveFit", "Common.m"]];
Get[ToFileName["CurveFit", "Data.m"]];
Get[ToFileName["CurveFit", "Transform.m"]];
Get[ToFileName["CurveFit", "Phase.m"]];
Get[ToFileName["CurveFit", "FileIO.m"]];
Get[ToFileName["CurveFit", "Gamma.m"]];
Get[ToFileName["CurveFit", "Fit.m"]];
Get[ToFileName["CurveFit", "Plots.m"]];
Get[ToFileName["CurveFit", "Select.m"]];
Get[ToFileName["CurveFit", "1D.m"]];

(* get rid of any Global symbols which shadow CurveFit symbols *)
Remove/@((StringJoin["Global`",#])&)/@
	Names["CurveFit`*"]//Quiet;

(***********************************************************)
Begin["`Private`"];
(* Restore the original status of spelling messages *)
If[spellFlag, On[General::"spell"]]
If[spell1Flag, On[General::"spell1"]]
If[commaFlag, On[Syntax::"com"]]
If[shdwFlag, On[General::"shdw"]]
ClearAll[spellFlag, spell1Flag, commaFlag, shdwFlag]
Remove[spellFlag, spell1Flag, commaFlag, shdwFlag]
End[]; (* `Private` *)

EndPackage[]; (* CurveFit` *)

