(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41546,        966]
NotebookOptionsPosition[     37489,        878]
NotebookOutlinePosition[     38128,        901]
CellTagsIndexPosition[     38085,        898]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Install the CurveFit package for Mathematica", "Subtitle",
 CellChangeTimes->{{3.4097007193963747`*^9, 3.4097007442401247`*^9}, {
  3.5346000762797318`*^9, 
  3.5346000806759834`*^9}},ExpressionUUID->"5e10a1c2-1df4-4481-86bb-\
d70a26fa9f28"],

Cell["\<\
Version 1.99g
Apr 2024, California Institute of Technology, Pasadena, CA
\
\>", "Subsubtitle",
 CellChangeTimes->{{3.6610026873287663`*^9, 3.661002722218815*^9}, {
   3.6610027826288996`*^9, 3.661002839028979*^9}, {3.731862303126487*^9, 
   3.731862313986108*^9}, {3.8127229812401977`*^9, 3.812722983979558*^9}, {
   3.8134134355391006`*^9, 3.8134134413659763`*^9}, {3.8135789691302867`*^9, 
   3.813578981771579*^9}, {3.8140243898373346`*^9, 3.814024390567851*^9}, {
   3.8184363657961793`*^9, 3.8184363705956163`*^9}, {3.854896483944138*^9, 
   3.8548964934013996`*^9}, {3.9132205784393177`*^9, 3.9132205992678156`*^9}, 
   3.915558227584039*^9, {3.92039264259558*^9, 3.920392650940279*^9}, {
   3.9221354141029797`*^9, 
   3.9221354181697707`*^9}},ExpressionUUID->"ee849b01-895a-4de0-8e51-\
439fc2515030"],

Cell[CellGroupData[{

Cell["Installer function definitions", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.389030985563875*^9, 
  3.389030993267*^9}},ExpressionUUID->"03544b13-d1f3-4b43-b69e-f5822bea48c2"],

Cell[CellGroupData[{

Cell["directories", "Subsubsection",
 CellChangeTimes->{{3.408990097828125*^9, 
  3.40899010015625*^9}},ExpressionUUID->"082285db-b7f3-4819-a2f6-\
2ce027a89418"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"allusersdir", " ", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{"$BaseDirectory", ",", "\"\<Applications\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"oneuserdir", " ", "=", " ", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{"$UserBaseDirectory", ",", "\"\<Applications\>\""}], "}"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"docsdir", " ", "=", " ", "$UserDocumentsDirectory"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"curvefitdir", " ", "=", " ", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{"docsdir", ",", "\"\<CurveFit\>\""}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"thisdir", " ", "=", " ", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"packagedir", " ", "=", " ", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{"thisdir", ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"$VersionNumber", " ", "<", " ", "10.0"}], ",", " ", 
        "\"\<legacy_package\>\"", ",", " ", "\"\<package\>\""}], "]"}]}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.389026818532625*^9, 3.38902688236075*^9}, {
   3.38902692686075*^9, 3.389027012501375*^9}, {3.389027049938875*^9, 
   3.38902711679825*^9}, {3.38902858929825*^9, 3.38902859717325*^9}, {
   3.389028632782625*^9, 3.3890286670795*^9}, {3.389028709313875*^9, 
   3.389028717345125*^9}, 3.389028873345125*^9, {3.389028984876375*^9, 
   3.389029042313875*^9}, {3.408897499226203*^9, 3.408897514023078*^9}, {
   3.408898132898078*^9, 3.408898133710578*^9}, {3.408898265929328*^9, 
   3.408898294960578*^9}, {3.408898423679328*^9, 3.408898427835578*^9}, {
   3.408898476929328*^9, 3.408898514007453*^9}, {3.408912264194953*^9, 
   3.408912337585578*^9}, {3.408912448491828*^9, 3.408912475679328*^9}, {
   3.408913296632453*^9, 3.408913365241828*^9}, 3.408913485257453*^9, {
   3.408914368538703*^9, 3.408914403023078*^9}, {3.4089947615625*^9, 
   3.408994782609375*^9}, 3.408994819015625*^9, {3.408995191109375*^9, 
   3.408995200609375*^9}, 3.40899523740625*^9, {3.408995421234375*^9, 
   3.408995487671875*^9}, {3.415468204163375*^9, 3.4154682263665*^9}, {
   3.5457462367055655`*^9, 3.545746243397977*^9}, {3.545746289542858*^9, 
   3.545746315017703*^9}, {3.6610025637685933`*^9, 3.6610026071186543`*^9}, {
   3.661009558743677*^9, 3.661009559663678*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"6420db70-a64a-459c-a996-865d1ea41b9c"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
message box with optional beep that requires an OK press to continue\
\>", "Subsubsection",
 CellChangeTimes->{{3.408990097828125*^9, 3.40899010015625*^9}, {
  3.40899051096875*^9, 3.408990531125*^9}, {3.818778564449433*^9, 
  3.8187785673942943`*^9}},ExpressionUUID->"1e975436-d2dd-4ed2-a523-\
4089d2a3423b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"alertdialog", "[", "s_String", "]"}], ":=", " ", 
  RowBox[{"DialogInput", "[", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"Style", "[", 
        RowBox[{"s", ",", "\"\<Text\>\"", ",", "16"}], "]"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DefaultButton", "[", 
       RowBox[{"\"\<    OK    \>\"", ",", 
        RowBox[{"DialogReturn", "[", "True", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.40899042003125*^9, 3.40899043675*^9}, {
   3.408990469421875*^9, 3.4089904950625*^9}, {3.4089906235*^9, 
   3.40899069334375*^9}, {3.408990747890625*^9, 3.408990782046875*^9}, {
   3.40899083978125*^9, 3.408990875234375*^9}, {3.818349440992858*^9, 
   3.8183494546261396`*^9}, {3.818349651043399*^9, 3.8183496516783895`*^9}, {
   3.8183498271914215`*^9, 3.8183498307928963`*^9}, 3.8187786331914263`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"8e1573cc-4640-41f0-8ae2-3242fdd3752b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"alertdialog", "[", 
   RowBox[{"s_String", ",", "\"\<Beep\>\""}], "]"}], ":=", " ", 
  RowBox[{"DialogInput", "[", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Beep", "[", "]"}], ";", 
       RowBox[{"TextCell", "[", 
        RowBox[{"Style", "[", 
         RowBox[{"s", ",", "\"\<Text\>\"", ",", "16"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"DefaultButton", "[", 
       RowBox[{"\"\<    OK    \>\"", ",", 
        RowBox[{"DialogReturn", "[", "True", "]"}]}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], "]"}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.40899042003125*^9, 3.40899043675*^9}, {
  3.408990469421875*^9, 3.4089904950625*^9}, {3.4089906235*^9, 
  3.40899069334375*^9}, {3.408990747890625*^9, 3.408990782046875*^9}, {
  3.40899083978125*^9, 3.408990875234375*^9}, {3.818349440992858*^9, 
  3.8183494546261396`*^9}, {3.818349651043399*^9, 3.8183496516783895`*^9}, {
  3.8183498271914215`*^9, 3.8183498307928963`*^9}, {3.818778603654436*^9, 
  3.8187786084703608`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"8c1a3c68-54b4-4fcf-945d-28717535b492"]
}, Closed]],

Cell[CellGroupData[{

Cell["copy with prompt to replace", "Subsubsection",
 CellChangeTimes->{{3.408990114578125*^9, 
  3.40899012746875*^9}},ExpressionUUID->"086db24d-2628-4a4e-bef6-\
612ce7baf95c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"filecopier", "[", 
    RowBox[{"sourcedir_", ",", " ", "destdir_", ",", "file_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FileNames", "[", 
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{"destdir", ",", "file"}], "}"}], "]"}], "]"}], "==", 
       RowBox[{"{", "}"}]}], " ", "||", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ChoiceDialog", "[", 
         RowBox[{"TextCell", "[", 
          RowBox[{
           RowBox[{"Beep", "[", "]"}], ";", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"\"\<Destination file \>\"", "<>", "\[IndentingNewLine]", 
              RowBox[{"FileNameJoin", "[", 
               RowBox[{"{", 
                RowBox[{"destdir", ",", "file"}], "}"}], "]"}], "<>", 
              "\"\< exists. Replace it?\>\""}], ",", "\"\<Text\>\"", ",", 
             "16"}], "]"}]}], "]"}], "]"}], "\[IndentingNewLine]", "&&", " ", 
        RowBox[{
         RowBox[{"DeleteFile", "[", 
          RowBox[{"FileNameJoin", "[", 
           RowBox[{"{", 
            RowBox[{"destdir", ",", "file"}], "}"}], "]"}], "]"}], "=!=", 
         "$Failed"}]}], ")"}]}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"CopyFile", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"sourcedir", ",", "file"}], "}"}], "]"}], ",", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"destdir", ",", "file"}], "}"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "$Failed"}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.389026818532625*^9, 3.38902688236075*^9}, {
   3.38902692686075*^9, 3.389027012501375*^9}, {3.389027049938875*^9, 
   3.38902711679825*^9}, {3.38902858929825*^9, 3.38902859717325*^9}, {
   3.389028632782625*^9, 3.3890286670795*^9}, {3.389028709313875*^9, 
   3.389028717345125*^9}, 3.389028873345125*^9, {3.389028984876375*^9, 
   3.389029042313875*^9}, {3.408897499226203*^9, 3.408897514023078*^9}, {
   3.408898132898078*^9, 3.408898133710578*^9}, {3.408898265929328*^9, 
   3.408898294960578*^9}, {3.408898423679328*^9, 3.408898427835578*^9}, {
   3.408898476929328*^9, 3.408898514007453*^9}, {3.408913696835578*^9, 
   3.408913712882453*^9}, 3.4089903769375*^9, {3.408991185*^9, 
   3.408991232546875*^9}, 3.4089913389375*^9, {3.545747151459972*^9, 
   3.5457471875116353`*^9}, {3.5457473009082346`*^9, 
   3.5457473072106457`*^9}, {3.545747340438704*^9, 3.545747354556729*^9}, {
   3.545748162860549*^9, 3.545748168351759*^9}, {3.8183495253846817`*^9, 
   3.818349537627311*^9}, {3.81834964317598*^9, 3.8183496437429385`*^9}, {
   3.818349865522518*^9, 3.8183498719369707`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"8a62d521-8f4e-49d1-8813-f7b805f6574d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dircopier", "[", 
    RowBox[{"sourcedir_", ",", " ", "destdir_", ",", "dir_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"If", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"FileNames", "[", 
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{"destdir", ",", "dir"}], "}"}], "]"}], "]"}], "==", 
       RowBox[{"{", "}"}]}], " ", "||", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ChoiceDialog", "[", 
         RowBox[{"TextCell", "[", 
          RowBox[{
           RowBox[{"Beep", "[", "]"}], ";", 
           RowBox[{"Style", "[", 
            RowBox[{
             RowBox[{"\"\<Destination directory \>\"", "<>", 
              RowBox[{"FileNameJoin", "[", 
               RowBox[{"{", 
                RowBox[{"destdir", ",", "dir"}], "}"}], "]"}], "<>", 
              "\"\< exists. Replace its contents?\>\""}], ",", "\"\<Text\>\"",
              ",", "16"}], "]"}]}], "]"}], "]"}], "\[IndentingNewLine]", "&&",
         " ", 
        RowBox[{
         RowBox[{"DeleteDirectory", "[", 
          RowBox[{
           RowBox[{"FileNameJoin", "[", 
            RowBox[{"{", 
             RowBox[{"destdir", ",", "dir"}], "}"}], "]"}], ",", 
           RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], "=!=", 
         "$Failed"}]}], ")"}]}], ",", "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"CopyDirectory", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"sourcedir", ",", "dir"}], "}"}], "]"}], ",", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"destdir", ",", "dir"}], "}"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "$Failed"}], "\[IndentingNewLine]", "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.389026818532625*^9, 3.38902688236075*^9}, {
   3.38902692686075*^9, 3.389027012501375*^9}, {3.389027049938875*^9, 
   3.38902711679825*^9}, {3.38902858929825*^9, 3.38902859717325*^9}, {
   3.389028632782625*^9, 3.3890286670795*^9}, {3.389028709313875*^9, 
   3.389028717345125*^9}, 3.389028873345125*^9, {3.389028984876375*^9, 
   3.389029042313875*^9}, {3.408897499226203*^9, 3.408897514023078*^9}, {
   3.408898132898078*^9, 3.408898133710578*^9}, {3.408898265929328*^9, 
   3.408898294960578*^9}, {3.408898423679328*^9, 3.408898427835578*^9}, {
   3.408898476929328*^9, 3.408898569944953*^9}, {3.408898658944953*^9, 
   3.408898662866828*^9}, 3.408898708944953*^9, {3.408898760773078*^9, 
   3.408898768273078*^9}, 3.408899025788703*^9, 3.408990382984375*^9, {
   3.5457481978826103`*^9, 3.545748252201906*^9}, {3.8183499132281084`*^9, 
   3.8183499292400646`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"d3cfd6e9-e352-4d43-8b2d-b9ec064b0f31"]
}, Closed]],

Cell[CellGroupData[{

Cell["Remove (clean) CurveFit directories and files", "Subsubsection",
 CellChangeTimes->{{3.408990114578125*^9, 3.40899012746875*^9}, {
  3.408991690609375*^9, 3.40899170228125*^9}, {3.408991736078125*^9, 
  3.408991754578125*^9}, {3.813416208427174*^9, 3.813416246841132*^9}, {
  3.8134173405762296`*^9, 3.813417355194292*^9}, {3.8135022309294195`*^9, 
  3.8135022344144936`*^9}},ExpressionUUID->"f32ea38a-2530-4575-8964-\
78492f3b5b66"],

Cell[TextData[{
 "\n",
 StyleBox["Execute ",
  FontSize->14],
 StyleBox["RemoveCurveFit[]",
  FontFamily->"Courier New",
  FontSize->14],
 StyleBox[" to erase the CurveFit and ErrorBarLogPlots packages and the \
CurveFit documents folder from your system. It will prompt for confirmations \
before removing from various locations.",
  FontSize->14]
}], "Text",
 CellChangeTimes->{
  3.813502246362544*^9, {3.813502293353173*^9, 3.813502440183752*^9}, {
   3.81350255403436*^9, 
   3.813502556953189*^9}},ExpressionUUID->"0c3f73d3-6ff6-4615-9201-\
5506e96d22b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"RemoveCurveFit", "[", "]"}], ":=", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"FileNames", "[", 
         RowBox[{"FileNameJoin", "[", 
          RowBox[{"{", 
           RowBox[{"allusersdir", ",", "\"\<CurveFit\>\""}], "}"}], "]"}], 
         "]"}], "\[NotEqual]", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "&&", 
       RowBox[{"confirmRemove", "[", 
        RowBox[{
        "\"\<the CurveFit and ErrorBaLogPlots packages for ALL USERS\>\"", 
         ",", "\"\<packages for All Users\>\""}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"removeCurveFitPackage", "[", "allusersdir", "]"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"FileNames", "[", 
         RowBox[{"FileNameJoin", "[", 
          RowBox[{"{", 
           RowBox[{"oneuserdir", ",", "\"\<CurveFit\>\""}], "}"}], "]"}], 
         "]"}], "\[NotEqual]", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "&&", 
       RowBox[{"confirmRemove", "[", 
        RowBox[{
        "\"\<the CurveFit and ErrorBaLogPlots packages for JUST YOU\>\"", 
         ",", "\"\<packages for Just You\>\""}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"removeCurveFitPackage", "[", "oneuserdir", "]"}]}], 
     "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"FileNames", "[", "curvefitdir", "]"}], "\[NotEqual]", 
        RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "&&", 
       RowBox[{"confirmRemove", "[", 
        RowBox[{
        "\"\<the CurveFit folder in your documents directory\>\"", ",", 
         "\"\<CurveFit documents\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"removeCurveFitDocuments", "[", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", ")"}]}]], "Input",
 CellChangeTimes->{{3.8135025685374556`*^9, 3.8135025939264464`*^9}, {
  3.8135026335652237`*^9, 3.8135027069613237`*^9}, {3.813502747043737*^9, 
  3.8135028346573405`*^9}, {3.813502873255848*^9, 3.8135029240436635`*^9}, {
  3.813503014671308*^9, 3.8135031565137157`*^9}, {3.8135032297073984`*^9, 
  3.813503329568243*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"2749472e-192a-4979-ab27-dbe08a3bac25"],

Cell[BoxData[
 RowBox[{
  RowBox[{"confirmRemove", "[", 
   RowBox[{"s_", ",", "st_"}], "]"}], ":=", 
  RowBox[{"ChoiceDialog", "[", 
   RowBox[{
    RowBox[{"Column", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Beep", "[", "]"}], ";", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
            "\"\<Completely remove \>\"", "<>", "s", "<>", "\"\<.\>\""}], ",",
             "14"}], "]"}]}], ")"}], ",", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Are your sure?\>\"", ",", "14"}], "]"}], ",", ",", 
        "\[IndentingNewLine]", 
        "\"\<You will then need to reinstall it from the package \
distribution.\>\""}], "}"}], ",", "Center"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<No, Cancel\>\"", "\[Rule]", "False"}], ",", 
      RowBox[{"\"\<Yes, Remove\>\"", "\[Rule]", "True"}]}], "}"}], ",", 
    RowBox[{"WindowTitle", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{"\"\<Remove \>\"", "<>", "st"}], ")"}]}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8134986526008053`*^9, 3.813498828637389*^9}, {
   3.813498972805692*^9, 3.813499006344738*^9}, 3.8134997856350613`*^9, {
   3.813502845561844*^9, 3.8135028531023116`*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"64071427-5f24-4ea7-ade2-e1480ac3e44f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"removeCurveFitPackage", "[", "dir_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Quiet", "[", 
      RowBox[{"DeleteDirectory", "[", 
       RowBox[{
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{"dir", ",", "\"\<CurveFit\>\""}], "}"}], "]"}], ",", 
        RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Quiet", "[", 
      RowBox[{"DeleteFile", "[", 
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"dir", ",", "\"\<ErrorBarLogPlots.m\>\""}], "}"}], "]"}], 
       "]"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Quiet", "[", 
      RowBox[{"DeleteDirectory", "[", 
       RowBox[{
        RowBox[{"FileNameJoin", "[", 
         RowBox[{"{", 
          RowBox[{"dir", ",", "\"\<ErrorBarLogPlots\>\""}], "}"}], "]"}], ",", 
        RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], "]"}], ";"}], 
    ")"}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"removeCurveFitDocuments", "[", "]"}], ":=", 
  RowBox[{"Quiet", "[", 
   RowBox[{"DeleteDirectory", "[", 
    RowBox[{"curvefitdir", ",", 
     RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], 
   "]"}]}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8134174152347465`*^9, 3.813417516068022*^9}, {
  3.8134175877472286`*^9, 3.8134176109062862`*^9}, {3.8134980042060356`*^9, 
  3.8134980104563117`*^9}, {3.813502168736227*^9, 3.813502178915916*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"4eaaabc4-570b-4a4e-b20c-2451ce266224"]
}, Closed]],

Cell[CellGroupData[{

Cell["install the packages to the proper locations", "Subsubsection",
 CellChangeTimes->{{3.408990114578125*^9, 3.40899012746875*^9}, {
  3.408991690609375*^9, 
  3.40899170228125*^9}},ExpressionUUID->"f5431596-53d4-452d-9f83-\
6c37ba69e1db"],

Cell[BoxData[
 RowBox[{
  RowBox[{"installCurveFitPackage", "[", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"dir", ",", "TipAll", ",", "TipUser"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"TipAll", "=", 
      RowBox[{
      "\"\<To install for all users, you must usually first run Mathematica \
as an Administrator or as Root. \>\"", "<>", "\[IndentingNewLine]", 
       "\"\<The installation may fail if you first execute \>\"", "<>", 
       "\"\<(double-click) this notebook to start and initialize Mathematica.\
\>\""}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
     "TipUser", "=", 
      "\"\<This is usually the correct option to choose.\>\""}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"dir", "=", 
          RowBox[{"ChoiceDialog", "[", 
           RowBox[{
            RowBox[{"TextCell", "[", 
             RowBox[{
              RowBox[{"Beep", "[", "]"}], ";", 
              RowBox[{"Style", "[", 
               RowBox[{
               "\"\<Install the CurveFit package?\>\"", ",", "\"\<Text\>\"", 
                ",", "16"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"Tooltip", "[", 
                RowBox[{"\"\<For just you\>\"", ",", "TipUser"}], "]"}], 
               "\[Rule]", "oneuserdir"}], ",", 
              RowBox[{
               RowBox[{"Tooltip", "[", 
                RowBox[{"\"\<For all users\>\"", ",", "TipAll"}], "]"}], 
               "\[Rule]", "allusersdir"}], ",", "\[IndentingNewLine]", 
              RowBox[{"\"\<Cancel\>\"", "\[Rule]", "$Canceled"}]}], "}"}]}], 
           "]"}]}], ")"}], "=!=", "$Canceled"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
         RowBox[{
         "If", " ", "installing", " ", "for", " ", "all", " ", "users"}], ",",
          " ", 
         RowBox[{
         "and", " ", "oneuserdir", " ", "has", " ", "CurveFit", " ", "or", 
          " ", "ErrorBarLogPlots"}], ",", " ", 
         RowBox[{"delete", " ", "it"}]}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", " ", 
         RowBox[{
          RowBox[{"dir", "===", "allusersdir"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Quiet", "[", 
            RowBox[{"DeleteDirectory", "[", 
             RowBox[{
              RowBox[{"FileNameJoin", "[", 
               RowBox[{"{", 
                RowBox[{"oneuserdir", ",", "\"\<CurveFit\>\""}], "}"}], "]"}],
               ",", 
              RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], "]"}], 
           ";", "\[IndentingNewLine]", 
           RowBox[{"Quiet", "[", 
            RowBox[{"DeleteFile", "[", 
             RowBox[{"FileNameJoin", "[", 
              RowBox[{"{", 
               RowBox[{"oneuserdir", ",", "\"\<ErrorBarLogPlots.m\>\""}], 
               "}"}], "]"}], "]"}], "]"}], ";", "\[IndentingNewLine]", 
           RowBox[{"Quiet", "[", 
            RowBox[{"DeleteDirectory", "[", 
             RowBox[{
              RowBox[{"FileNameJoin", "[", 
               RowBox[{"{", 
                RowBox[{"oneuserdir", ",", "\"\<ErrorBarLogPlots\>\""}], 
                "}"}], "]"}], ",", 
              RowBox[{"DeleteContents", "\[Rule]", "True"}]}], "]"}], 
            "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"dircopier", "[", 
            RowBox[{"packagedir", ",", "dir", ",", "\"\<CurveFit\>\""}], 
            "]"}], "=!=", " ", "$Failed"}], ",", "\[IndentingNewLine]", 
          RowBox[{
          "alertdialog", "[", "\"\<CurveFit package installed.\>\"", "]"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"alertdialog", "[", 
            RowBox[{
             RowBox[{
             "\"\<CurveFit package installation failed!\\n\>\"", "<>", 
              "\[IndentingNewLine]", 
              "\"\<An old file or directory may be Read-Only, or you may \
\>\"", "<>", "\[IndentingNewLine]", 
              "\"\<not have permission to write files to \>\"", "<>", " ", 
              "dir"}], ",", "\"\<Beep\>\""}], "\[IndentingNewLine]", "]"}], 
           ";", " ", "$Failed"}]}], "\[IndentingNewLine]", "]"}]}], ",", 
       "\[IndentingNewLine]", "$Canceled"}], "\[IndentingNewLine]", "]"}]}]}],
    "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.389028486907625*^9, 3.389028509313875*^9}, {
   3.389029530813875*^9, 3.389029545267*^9}, {3.389030214767*^9, 
   3.389030389626375*^9}, {3.389030573845125*^9, 3.389030577345125*^9}, {
   3.38903060767325*^9, 3.389030704267*^9}, {3.38903076054825*^9, 
   3.389030799188875*^9}, 3.408898801319953*^9, {3.408898834882453*^9, 
   3.408898835382453*^9}, {3.408898883991828*^9, 3.408898927429328*^9}, {
   3.408913758976203*^9, 3.408913805351203*^9}, {3.408914162023078*^9, 
   3.408914186694953*^9}, {3.408914229976203*^9, 3.408914260866828*^9}, {
   3.408914325835578*^9, 3.408914330429328*^9}, {3.408914426538703*^9, 
   3.408914486444953*^9}, {3.408914533429328*^9, 3.408914556288703*^9}, {
   3.408914696288703*^9, 3.408914727429328*^9}, 3.408914776835578*^9, {
   3.408914807398078*^9, 3.408914914991828*^9}, {3.408914954944953*^9, 
   3.408914962726203*^9}, {3.408915002585578*^9, 3.408915049569953*^9}, 
   3.408990392765625*^9, {3.408991504890625*^9, 3.408991549203125*^9}, {
   3.408991579609375*^9, 3.40899159734375*^9}, 3.408991632859375*^9, {
   3.408994236953125*^9, 3.408994262140625*^9}, {3.534600150005949*^9, 
   3.5346001567973375`*^9}, 3.534607448769414*^9, 3.534607492131894*^9, {
   3.5346075275529203`*^9, 3.534607545151927*^9}, {3.5346076009031153`*^9, 
   3.5346076884601235`*^9}, {3.5457483199528246`*^9, 
   3.5457483395776596`*^9}, {3.5457484211814027`*^9, 
   3.5457485265439873`*^9}, {3.545748558586444*^9, 3.5457485650604553`*^9}, 
   3.5457486277413654`*^9, {3.5671938748632355`*^9, 3.5671939770590153`*^9}, {
   3.5671940275251036`*^9, 3.56719405948956*^9}, {3.567194091469616*^9, 
   3.567194171996958*^9}, {3.5671942427118816`*^9, 3.567194285409157*^9}, {
   3.56719433291124*^9, 3.567194351834073*^9}, {3.567194386934135*^9, 
   3.5671944791770973`*^9}, {3.5671947669352026`*^9, 
   3.5671947857800355`*^9}, {3.812723605660261*^9, 3.812723608195527*^9}, {
   3.812724175227661*^9, 3.8127245059157057`*^9}, {3.812728262811701*^9, 
   3.8127283247039604`*^9}, {3.812728395518982*^9, 3.8127285505116773`*^9}, {
   3.8127286198447857`*^9, 3.8127286458295593`*^9}, {3.8183501031194744`*^9, 
   3.8183501162788386`*^9}, {3.81877870338723*^9, 3.818778720775131*^9}, {
   3.913219447988908*^9, 3.9132194874560595`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"d177fbbf-0b99-46e9-adaa-da9528f0dec4"]
}, Closed]],

Cell[CellGroupData[{

Cell["install the CurveFit folder in the user's documents area", \
"Subsubsection",
 CellChangeTimes->{{3.408990114578125*^9, 3.40899012746875*^9}, {
  3.408991690609375*^9, 3.40899170228125*^9}, {3.408991736078125*^9, 
  3.408991754578125*^9}},ExpressionUUID->"dfc2a222-8895-40a7-9bce-\
d37a9c7acc36"],

Cell[BoxData[
 RowBox[{
  RowBox[{"installCurveFitDocs", "[", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"If", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FileNames", "[", "curvefitdir", "]"}], "==", 
        RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"dircopier", "[", 
        RowBox[{"thisdir", ",", "docsdir", ",", "\"\<CurveFit\>\""}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dircopier", "[", 
            RowBox[{
             RowBox[{"FileNameJoin", "[", 
              RowBox[{"{", 
               RowBox[{"thisdir", ",", "\"\<CurveFit\>\""}], "}"}], "]"}], 
             ",", "curvefitdir", ",", "\"\<Sample Data\>\""}], "]"}], "===", 
           "$Failed"}], " ", "||", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"filecopier", "[", 
            RowBox[{
             RowBox[{"FileNameJoin", "[", 
              RowBox[{"{", 
               RowBox[{"thisdir", ",", "\"\<CurveFit\>\""}], "}"}], "]"}], 
             ",", "curvefitdir", ",", "\"\<Launch.nb\>\""}], "]"}], "===", 
           "$Failed"}], "  ", "||", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"filecopier", "[", 
            RowBox[{
             RowBox[{"FileNameJoin", "[", 
              RowBox[{"{", 
               RowBox[{"thisdir", ",", "\"\<CurveFit\>\""}], "}"}], "]"}], 
             ",", "curvefitdir", ",", "\"\<FitAnyFunction.nb\>\""}], "]"}], "===",
            "$Failed"}], "  ", "||", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"filecopier", "[", 
            RowBox[{
             RowBox[{"FileNameJoin", "[", 
              RowBox[{"{", 
               RowBox[{"thisdir", ",", "\"\<CurveFit\>\""}], "}"}], "]"}], 
             ",", "curvefitdir", ",", "\"\<ReadMe.txt\>\""}], "]"}], "===", 
           "$Failed"}]}], " ", ",", "\[IndentingNewLine]", "$Failed"}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}], " ", "===",
      " ", "$Failed"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"alertdialog", "[", 
      RowBox[{
       RowBox[{
       "\"\<Unable to copy all CurveFit sample files!\\n\>\"", "<>", 
        "\[IndentingNewLine]", 
        "\"\<An old file or directory may be Read-Only, or you \>\"", "<>", 
        "\"\<\n\tcancelled a particular copy operation.\>\""}], ",", 
       "\"\<Beep\>\""}], "]"}], ";", "$Failed"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
     "alertdialog", "[", "\"\<CurveFit sample files installed.\>\"", "]"}], 
     ";", "True"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.408991774671875*^9, 3.408991838328125*^9}, {
   3.408991926484375*^9, 3.4089919461875*^9}, {3.40899199965625*^9, 
   3.408992001*^9}, {3.40899271215625*^9, 3.408992750890625*^9}, {
   3.4089935030625*^9, 3.4089935764375*^9}, {3.408993635171875*^9, 
   3.40899366109375*^9}, {3.408993692203125*^9, 3.408993694546875*^9}, {
   3.4089937256875*^9, 3.40899375353125*^9}, {3.4089938700625*^9, 
   3.408993880046875*^9}, {3.408994006765625*^9, 3.408994153703125*^9}, {
   3.40899429434375*^9, 3.40899445378125*^9}, 3.40899559925*^9, {
   3.41546791939775*^9, 3.415467927288375*^9}, {3.5346003452421155`*^9, 
   3.534600357369809*^9}, {3.545748707816306*^9, 3.5457487626036024`*^9}, {
   3.5457488550181646`*^9, 3.5457488840030155`*^9}, 3.7322092651552634`*^9, {
   3.73220936388091*^9, 3.732209368051149*^9}, {3.8187789133840723`*^9, 
   3.8187789785123234`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"a06f81ca-74c3-4e67-b3ed-026ec61fd260"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Installer run code", "Subsection",
 InitializationCell->True,
 CellChangeTimes->{{3.389031006657625*^9, 3.389031009751375*^9}, {
  3.8127247106634846`*^9, 
  3.8127247348660574`*^9}},ExpressionUUID->"fc0dd913-2b5b-4268-ab34-\
5e6786f1bf73"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"$VersionNumber", " ", "\[GreaterEqual]", " ", "12.2"}], ",", 
    "\n", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"status", " ", "=", 
        RowBox[{"installCurveFitPackage", "[", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"status", "=!=", "$Canceled"}], " ", "&&", " ", 
         RowBox[{"status", "=!=", "$Failed"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"installCurveFitDocs", "[", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"SelectionMove", "[", 
          RowBox[{
           RowBox[{"EvaluationNotebook", "[", "]"}], ",", "After", ",", 
           "Notebook"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"SelectionMove", "[", 
          RowBox[{
           RowBox[{"EvaluationNotebook", "[", "]"}], ",", "Previous", ",", 
           "Cell"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"SelectionEvaluateCreateCell", "[", 
          RowBox[{"EvaluationNotebook", "[", "]"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"SelectionMove", "[", 
          RowBox[{
           RowBox[{"EvaluationNotebook", "[", "]"}], ",", "After", ",", 
           "Notebook"}], "]"}]}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", "status"}], "]"}]}], " ", 
     "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", "CurveFit", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"CurveFit", "::", "version"}], " ", "=", " ", 
        "\"\<You need at least Mathematica Version 12.2 for this \
package!\>\""}], ";", 
       RowBox[{"Message", "[", 
        RowBox[{"CurveFit", "::", "version"}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Block", "[", 
     RowBox[{
      RowBox[{"{", "CurveFit", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"CurveFit", "::", "version"}], " ", "=", " ", 
        "\"\<You need at least Mathematica Version 12.2 for this \
package!\>\""}], ";", 
       RowBox[{"Message", "[", 
        RowBox[{"CurveFit", "::", "version"}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}], "\n", "]"}], "\n"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.38903089423575*^9, 3.3890309308295*^9}, 
   3.408915219382453*^9, {3.40899452365625*^9, 3.40899460565625*^9}, {
   3.408994638578125*^9, 3.40899467390625*^9}, {3.4097000147557497`*^9, 
   3.4097001502557497`*^9}, {3.5457489368871083`*^9, 3.545748957572745*^9}, {
   3.8127237889277906`*^9, 3.812723810101609*^9}, {3.812724924842807*^9, 
   3.812724979803816*^9}, 3.8127250562376995`*^9, {3.8127251885695267`*^9, 
   3.8127251952945633`*^9}, {3.8127252867268157`*^9, 
   3.8127253026594906`*^9}, {3.8127254688959446`*^9, 
   3.8127254804669957`*^9}, {3.8127266193706813`*^9, 
   3.8127266570012093`*^9}, {3.812727931709447*^9, 3.8127279446290607`*^9}, {
   3.913219606887471*^9, 3.9132196119870853`*^9}, {3.9132196439747925`*^9, 
   3.9132196440347567`*^9}, {3.9155582724372234`*^9, 
   3.915558280155769*^9}},ExpressionUUID->"115ee1d9-e5c2-421c-ac42-\
786e50536858"]
}, Closed]],

Cell[CellGroupData[{

Cell["How to load and launch CurveFit :", "Subsection",
 CellChangeTimes->{{3.38903111161075*^9, 3.389031123220125*^9}, {
  3.4096999010682497`*^9, 3.4096999100682497`*^9}, {3.812728194880849*^9, 
  3.812728212769787*^9}},ExpressionUUID->"628dd2ca-b0a4-4a35-a90a-\
6923d8135bea"],

Cell[CellGroupData[{

Cell["\<\
The CurveFit Launch notebook and the sample data files are in directory :\
\>", "Subsubsection",
 CellChangeTimes->{{3.4097004857401247`*^9, 
  3.4097005218807497`*^9}},ExpressionUUID->"38f6278c-46a7-40fa-81b0-\
ffb8d90572f4"],

Cell[CellGroupData[{

Cell[BoxData["curvefitdir"], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.4097005839276247`*^9, 3.4097005870369997`*^9}, 
   3.545749047444503*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"9ca1298a-eeaa-4674-98a1-ccd3db37107d"],

Cell[BoxData["\<\"C:\\\\Users\\\\rice\\\\OneDrive\\\\Documents\\\\CurveFit\"\>\
"], "Output",
 CellChangeTimes->{3.8183412936475053`*^9, 3.8183413514956646`*^9, 
  3.8183489886520867`*^9, 3.818350399850933*^9, 3.818426189505857*^9, 
  3.8184265974983473`*^9, 3.8184321965085354`*^9, 3.8184329730841727`*^9, 
  3.8184332707568197`*^9, 3.818436151564252*^9, 3.8184508842346544`*^9, 
  3.818520957394931*^9, 3.818522865040889*^9, 3.8185242355189977`*^9, 
  3.8185245576500854`*^9, 3.8185339673489804`*^9, 3.818620128123915*^9, 
  3.818632292804882*^9, 3.818692001692268*^9, 3.818692769674322*^9, 
  3.913220453434806*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"ae85c2d6-b7ad-4a8e-89f6-f1c9f6f3161d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Here we open the Launch notebook. Run its initialization code to start \
CurveFit:\
\>", "Subsubsection",
 CellChangeTimes->{{3.4097005994901247`*^9, 3.4097006219744997`*^9}, 
   3.4097007720682497`*^9, {3.8183453555895605`*^9, 
   3.8183454028437405`*^9}},ExpressionUUID->"b9ee8845-67b5-46f7-bf53-\
9318e7aad20c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookOpen", "[", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{"curvefitdir", ",", "\"\<Launch.nb\>\""}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8183413585822706`*^9, 3.8183413616553507`*^9}, 
   3.818345430312501*^9, {3.8183454660805364`*^9, 3.818345473571782*^9}, {
   3.81834566367061*^9, 3.818345665790945*^9}, {3.818345702060101*^9, 
   3.818345720506897*^9}, {3.818345780515579*^9, 3.818345780916582*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"9501ad34-3a6c-4795-a4af-a011ec6e90a6"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
Saveable->False,
InitializationCellEvaluation->True,
InitializationCellWarning->False,
WindowSize->{821, 692},
WindowMargins->{{471, Automatic}, {121, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> True}},
ShowSelection->True,
ShowCellLabel->False,
FrontEndVersion->"12.2 for Microsoft Windows (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"d6121c1b-afa7-48b1-a135-df50f56ec137"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 247, 4, 49, "Subtitle",ExpressionUUID->"5e10a1c2-1df4-4481-86bb-d70a26fa9f28"],
Cell[817, 28, 818, 15, 66, "Subsubtitle",ExpressionUUID->"ee849b01-895a-4de0-8e51-439fc2515030"],
Cell[CellGroupData[{
Cell[1660, 47, 200, 3, 36, "Subsection",ExpressionUUID->"03544b13-d1f3-4b43-b69e-f5822bea48c2",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[1885, 54, 161, 3, 27, "Subsubsection",ExpressionUUID->"082285db-b7f3-4819-a2f6-2ce027a89418"],
Cell[2049, 59, 2637, 54, 154, "Input",ExpressionUUID->"6420db70-a64a-459c-a996-865d1ea41b9c",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[4723, 118, 319, 6, 21, "Subsubsection",ExpressionUUID->"1e975436-d2dd-4ed2-a523-4089d2a3423b"],
Cell[5045, 126, 1077, 22, 82, "Input",ExpressionUUID->"8e1573cc-4640-41f0-8ae2-3242fdd3752b",
 InitializationCell->True],
Cell[6125, 150, 1195, 26, 82, "Input",ExpressionUUID->"8c1a3c68-54b4-4fcf-945d-28717535b492",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[7357, 181, 177, 3, 21, "Subsubsection",ExpressionUUID->"086db24d-2628-4a4e-bef6-612ce7baf95c"],
Cell[7537, 186, 3003, 63, 226, "Input",ExpressionUUID->"8a62d521-8f4e-49d1-8813-f7b805f6574d",
 InitializationCell->True],
Cell[10543, 251, 2881, 63, 226, "Input",ExpressionUUID->"d3cfd6e9-e352-4d43-8b2d-b9ec064b0f31",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[13461, 319, 439, 6, 21, "Subsubsection",ExpressionUUID->"f32ea38a-2530-4575-8964-78492f3b5b66"],
Cell[13903, 327, 561, 16, 68, "Text",ExpressionUUID->"0c3f73d3-6ff6-4615-9201-5506e96d22b5"],
Cell[14467, 345, 2478, 58, 264, "Input",ExpressionUUID->"2749472e-192a-4979-ab27-dbe08a3bac25"],
Cell[16948, 405, 1375, 34, 100, "Input",ExpressionUUID->"64071427-5f24-4ea7-ade2-e1480ac3e44f",
 InitializationCell->True],
Cell[18326, 441, 1633, 39, 118, "Input",ExpressionUUID->"4eaaabc4-570b-4a4e-b20c-2451ce266224",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[19996, 485, 242, 4, 21, "Subsubsection",ExpressionUUID->"f5431596-53d4-452d-9f83-6c37ba69e1db"],
Cell[20241, 491, 7051, 141, 514, "Input",ExpressionUUID->"d177fbbf-0b99-46e9-adaa-da9528f0dec4",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[27329, 637, 302, 5, 21, "Subsubsection",ExpressionUUID->"dfc2a222-8895-40a7-9bce-d37a9c7acc36"],
Cell[27634, 644, 3721, 78, 316, "Input",ExpressionUUID->"a06f81ca-74c3-4e67-b3ed-026ec61fd260",
 InitializationCell->True]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31404, 728, 246, 5, 28, "Subsection",ExpressionUUID->"fc0dd913-2b5b-4268-ab34-5e6786f1bf73",
 InitializationCell->True],
Cell[31653, 735, 3281, 73, 406, "Input",ExpressionUUID->"115ee1d9-e5c2-421c-ac42-786e50536858",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[34971, 813, 279, 4, 28, "Subsection",ExpressionUUID->"628dd2ca-b0a4-4a35-a90a-6923d8135bea"],
Cell[CellGroupData[{
Cell[35275, 821, 236, 5, 27, "Subsubsection",ExpressionUUID->"38f6278c-46a7-40fa-81b0-ffb8d90572f4"],
Cell[CellGroupData[{
Cell[35536, 830, 239, 4, 45, "Input",ExpressionUUID->"9ca1298a-eeaa-4674-98a1-ccd3db37107d",
 InitializationCell->True],
Cell[35778, 836, 697, 10, 29, "Output",ExpressionUUID->"ae85c2d6-b7ad-4a8e-89f6-f1c9f6f3161d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36524, 852, 324, 7, 27, "Subsubsection",ExpressionUUID->"b9ee8845-67b5-46f7-bf53-9318e7aad20c"],
Cell[36851, 861, 598, 12, 45, "Input",ExpressionUUID->"9501ad34-3a6c-4795-a4af-a011ec6e90a6",
 InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

